package com.agilex.healthcare.directscheduling.dataservice;

import com.agilex.healthcare.directscheduling.integration.HttpClientService;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import gov.va.vamf.security.v1.VamfJwtClaimsConstants;
import gov.va.vamf.videoconnect.common.domain.Appointment;
import gov.va.vamf.scheduling.direct.datalayer.clinic.ClinicDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

import javax.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.*;

@Primary
@Service
@Scope(BeanDefinition.SCOPE_SINGLETON)
public class ConsolidatedService {

    @Autowired
    private Environment environment;

    @Autowired
    private HttpClientService<Appointment> httpAppointmentService;

    @Autowired
    private ClinicDataService clinicDataService;

    @Value("${book-veteran-videoconnect-resources}")
    String bookAppointmentUrl;

    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ConsolidatedService.class);
    private static final String ASSIGNING_AUTHORITY = "assigning-authority";
    private static final String PATIENT_ID = "patient-id";

    public ConsolidatedService() {
    }

    public Appointment bookMobileAnyAppointment(String jwtString, PatientIdentifier patientIdentifier, Appointment appointment) {

        URI uri = getBookAppointmentUri(patientIdentifier);

        Map<String, String> headerParams = new HashMap();
        headerParams.put(VamfJwtClaimsConstants.VAMF_JWT_HEADER, jwtString);
        Appointment bookedAppointment = httpAppointmentService.postCall(uri, Appointment.class, headerParams, appointment);

        return bookedAppointment;

    }

    private URI getBookAppointmentUri(PatientIdentifier patientIdentifier) {

        Map<String, String> pathParams = new HashMap<String, String>();
        pathParams.put(ASSIGNING_AUTHORITY, patientIdentifier.getAssigningAuthority());
        pathParams.put(PATIENT_ID, patientIdentifier.getUniqueId());

        return  UriBuilder.fromUri(bookAppointmentUrl).buildFromMap(pathParams);
    }
}
